package com.izenpe.zain.cliente.cades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

public class GeneracionFirmaCades_ES_T_Attached
{
	// Nombre del fichero a utilizar para la Generacin de la firma PKCS#7.
	private static final String fileName = "HelloWorld.txt";

	public static void main(String args[]) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil de firma CMS/PKCS#7 en la peticin de
			// Generacin de firma.
			smartSignReq.setProfile(Constants.Profile.CMSPKCS7);
			
			//Especificamos el subtipo CAdES
			smartSignReq.setSignatureType(Constants.SignatureType.CADES);
			
			// Indicamos que queremos realizar una firma con sello de tiempo
			smartSignReq.setSignatureFormat(Constants.SignatureFormat.ES_T);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartSignReq.setLanguage("es");
			
			// Certificado con el que realizar la firma.
			smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);

			/*
			 * Se solicita una firma attached. Los datos estarn embedded en la
			 * estructura de firma CMS o PKCS #7.
			 */
			smartSignReq.setEnvelopingSignature(true);
			

			// Datos a firmar.
			smartSignReq.setInputBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));

			// Envo de la peticin.
			SmartSignResponse smartSignResp = smartSignReq.send();

			/*
			 * Se comprueba la validez de la respuesta y se escribe la respuesta
			 * de Generacin de firma PKCS#7 en un fichero en disco.
			 */
			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				String signBase64 = smartSignResp.getSignatureBase64();
				byte[] data = Base64.decode(signBase64);
				String destFilename = "data/output/" + fileName + "_Attached.p7s";
				ZainUtil.writeBinaryFile(destFilename, data);
				System.out.println("La firma se ha generado con xito");
			} else {
				System.out.println("Error en la Generacin de Firma:" + smartSignResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}